/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.filewatcher.poller.epl;

import com.aptana.core.epl.CoreEPLPlugin;
import com.aptana.filewatcher.poller.epl.DirectoryChangeListener;
import com.aptana.filewatcher.poller.epl.Messages;
import java.io.File;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.osgi.util.NLS;

public class DirectoryWatcher {
    private static final long DEFAULT_POLL_FREQUENCY = 2000L;
    private final File[] directories;
    private Set<DirectoryChangeListener> listeners = new HashSet<DirectoryChangeListener>();
    private Set<File> scannedFiles = new HashSet<File>();
    private Set<File> removals;
    private WatcherThread watcher;
    private boolean watchSubdirs;

    private static void log(String string, Throwable e) {
        CoreEPLPlugin.log(string, e);
    }

    public DirectoryWatcher(File directory, boolean watchSubtree) {
        if (directory == null) {
            throw new IllegalArgumentException(Messages.null_folder);
        }
        this.directories = new File[]{directory};
        this.watchSubdirs = watchSubtree;
    }

    public synchronized void addListener(DirectoryChangeListener listener) {
        this.listeners.add(listener);
    }

    public synchronized void removeListener(DirectoryChangeListener listener) {
        this.listeners.remove(listener);
    }

    public void start() {
        this.start(2000L);
    }

    private synchronized void poll() {
        this.startPoll();
        this.scanDirectories();
        this.stopPoll();
    }

    private synchronized void start(long pollFrequency) {
        if (this.watcher != null) {
            throw new IllegalStateException(Messages.thread_started);
        }
        this.watcher = new WatcherThread(pollFrequency);
        this.watcher.start();
    }

    private synchronized void stop() {
        if (this.watcher == null) {
            throw new IllegalStateException(Messages.thread_not_started);
        }
        this.watcher.done();
        this.watcher = null;
    }

    public synchronized void dispose() {
        if (this.watcher != null) {
            this.stop();
        }
        if (this.listeners != null) {
            for (DirectoryChangeListener listener : this.listeners) {
                this.removeListener(listener);
            }
        }
    }

    private void startPoll() {
        this.removals = this.scannedFiles;
        this.scannedFiles = new HashSet<File>();
        Iterator<DirectoryChangeListener> i = this.listeners.iterator();
        while (i.hasNext()) {
            i.next().startPoll();
        }
    }

    private void scanDirectories() {
        int index = 0;
        while (index < this.directories.length) {
            File directory = this.directories[index];
            this.scanDirectoryRecursively(directory);
            ++index;
        }
    }

    private void scanDirectoryRecursively(File directory) {
        if (directory == null) {
            return;
        }
        File[] list = directory.listFiles();
        if (list == null) {
            return;
        }
        int i = 0;
        while (i < list.length) {
            File file = list[i];
            this.scannedFiles.add(file);
            this.removals.remove(file);
            for (DirectoryChangeListener listener : this.listeners) {
                if (!this.isInterested(listener, file)) continue;
                this.processFile(file, listener);
            }
            if (this.watchSubdirs && file.isDirectory()) {
                this.scanDirectoryRecursively(file);
            }
            ++i;
        }
    }

    private void stopPoll() {
        this.notifyRemovals();
        this.removals = this.scannedFiles;
        Iterator<DirectoryChangeListener> i = this.listeners.iterator();
        while (i.hasNext()) {
            i.next().stopPoll();
        }
    }

    private boolean isInterested(DirectoryChangeListener listener, File file) {
        return listener.isInterested(file);
    }

    private void notifyRemovals() {
        Set<File> removed = this.removals;
        for (DirectoryChangeListener listener : this.listeners) {
            for (File file : removed) {
                if (!this.isInterested(listener, file)) continue;
                listener.removed(file);
            }
        }
    }

    private void processFile(File file, DirectoryChangeListener listener) {
        try {
            Long oldTimestamp = listener.getSeenFile(file);
            if (oldTimestamp == null) {
                listener.added(file);
            } else {
                long lastModified = file.lastModified();
                if (oldTimestamp != lastModified) {
                    listener.changed(file);
                }
            }
        }
        catch (Exception e) {
            DirectoryWatcher.log(NLS.bind((String)Messages.error_processing, (Object)listener), e);
        }
    }

    private class WatcherThread
    extends Thread {
        private final long pollFrequency;
        private boolean done;

        private WatcherThread(long frequency) {
            super("Directory Watcher");
            this.done = false;
            this.pollFrequency = frequency;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            do {
                try {
                    DirectoryWatcher.this.poll();
                    WatcherThread watcherThread = this;
                    synchronized (watcherThread) {
                        this.wait(this.pollFrequency);
                    }
                }
                catch (InterruptedException interruptedException) {
                }
                catch (Throwable e) {
                    DirectoryWatcher.log(Messages.error_main_loop, e);
                    this.done = true;
                }
            } while (!this.done);
        }

        private synchronized void done() {
            this.done = true;
            this.notify();
        }
    }
}

